-- seedbedReconsolidation.lua
-- Autors: RedFoxModding, pielāgojis Grok
-- Versija: 1.2.0.0
-- Apraksts: Pievieno funkcionalitāti, kas sējas laikā automātiski iestata lauka statusu kā "rullēts" FS25.

-- Izmaiņu žurnāls:
-- 1.0.0.0: Sākotnējā versija FS22
-- 1.1.0.0: Labojumi FS22 patch 1.4
-- 1.2.0.0: Pielāgojumi FS25, pievienota kļūdu apstrāde un alternatīva API

SeedbedReconsolidation = {}

-- Pārbauda, vai sējmašīnas specializācija ir pieejama
function SeedbedReconsolidation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(SowingMachine, specializations)
end

-- Reģistrē pārrakstāmās funkcijas
function SeedbedReconsolidation.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "processSowingMachineArea", SeedbedReconsolidation.processSowingMachineArea)
end

-- Pārraksta sējas apstrādes funkciju, lai iestatītu rullēšanas statusu
function SeedbedReconsolidation:processSowingMachineArea(superFunc, workArea, dt)
    local spec = self.spec_sowingMachine
    if not spec then
        print("SeedbedReconsolidation: Sējmašīnas specializācija nav atrasta")
        return superFunc(self, workArea, dt)
    end

    -- Iegūst darba zonas koordinātas
    local xs, _, zs = getWorldTranslation(workArea.start)
    local xw, _, zw = getWorldTranslation(workArea.width)
    local xh, _, zh = getWorldTranslation(workArea.height)

    -- Mēģina atjaunināt rullēšanas statusu
    local success = false
    if FSDensityMapUtil and FSDensityMapUtil.updateRollerArea then
        -- Izmanto FS22/FS25 oriģinālo funkciju, ja tā ir pieejama
        local _, _ = FSDensityMapUtil.updateRollerArea(xs, zs, xw, zw, xh, zh, spec.workAreaParameters.angle)
        success = true
        print("SeedbedReconsolidation: Rullēšanas statuss atjaunināts ar updateRollerArea")
    elseif FSDensityMapUtil and FSDensityMapUtil.setGroundState then
        -- Alternatīva funkcija, ja FS25 ir mainījis API (pielāgo atbilstoši FS25 dokumentācijai)
        FSDensityMapUtil.setGroundState(xs, zs, xw, zw, xh, zh, "ROLLED")
        success = true
        print("SeedbedReconsolidation: Rullēšanas statuss atjaunināts ar setGroundState")
    else
        print("SeedbedReconsolidation: Rullēšanas funkcijas nav atrastas, pārbaudiet FS25 API")
    end

    -- Izsauc oriģinālo sējas funkciju
    local realArea, area = superFunc(self, workArea, dt)
    return realArea, area
end