-- RegisterSpec.lua
-- Autors: RedFoxModding, pielāgojis Grok
-- Versija: 1.2.0.0
-- Apraksts: Reģistrē SeedbedReconsolidation specializāciju visām sējmašīnām FS25.

-- Izmaiņu žurnāls:
-- 1.0.0.0: Sākotnējā versija FS22
-- 1.1.0.0: Labojumi FS22 patch 1.4
-- 1.2.0.0: Pielāgojumi FS25 saderībai, kļūdu apstrāde

RegisterSpec = {}
RegisterSpec.currentModDirectory = g_currentModDirectory

function RegisterSpec:addSpec()
    -- Pārbauda, vai specializācija jau nav reģistrēta
    if g_specializationManager:getSpecializationByName("SeedbedReconsolidation") == nil then
        -- Reģistrē specializāciju, norādot tās faila ceļu
        local specPath = Utils.getFilename("seedbedReconsolidation.lua", RegisterSpec.currentModDirectory)
        g_specializationManager:addSpecialization("SeedbedReconsolidation", "SeedbedReconsolidation", specPath, nil)
        print("SeedbedReconsolidation: Specializācija reģistrēta veiksmīgi")

        -- Pievieno specializāciju visām sējmašīnām
        for typeName, typeEntry in pairs(g_vehicleTypeManager.types) do
            if not SpecializationUtil.hasSpecialization(SeedbedReconsolidation, typeEntry.specializations) and 
               SpecializationUtil.hasSpecialization(SowingMachine, typeEntry.specializations) then
                g_vehicleTypeManager:addSpecialization(typeName, "SeedbedReconsolidation")
                print("SeedbedReconsolidation: Pievienota specializācija tehnikai: " .. tostring(typeName))
            end
        end
    else
        print("SeedbedReconsolidation: Specializācija jau ir reģistrēta")
    end
end

-- Pievieno funkciju tipu validācijas procesam
TypeManager.validateTypes = Utils.prependedFunction(TypeManager.validateTypes, RegisterSpec.addSpec)