---This class stores settings for the AutoFOV mod
---@class AutoFOVSettings
---@field targetFOV number @The target FOV value for outside cameras
---@field targetFOVInterior number @The target FOV value for inside cameras
---@field harvesterFOVInterior number @The target FOV value for harvester inside cameras
AutoFOVSettings = {
}
local AutoFOVSettings_mt = Class(AutoFOVSettings)

---Creates a new settings instance
---@return table @The new instance
function AutoFOVSettings.new()
	local self = setmetatable({}, AutoFOVSettings_mt)
	self.targetFOV = 30 -- Default value for outside
    self.targetFOVInterior = 60 -- Default value for inside
    self.harvesterFOVInterior = 75 -- Default value for harvester inside
	return self
end
