LeaseFarmlandEvent = {}

local LeaseFarmlandEvent_mt = Class(LeaseFarmlandEvent, Event)
InitEventClass(LeaseFarmlandEvent, "LeaseFarmlandEvent")

function LeaseFarmlandEvent.emptyNew()
	return Event.new(LeaseFarmlandEvent_mt)
end

function LeaseFarmlandEvent.new(lease, farmlandId, farmId, price)
	local self = LeaseFarmlandEvent.emptyNew()
    self.lease = lease
	self.farmlandId = farmlandId
	self.farmId = farmId
    self.price = price
	return self
end

function LeaseFarmlandEvent:readStream(streamId, connection)
	self.lease = streamReadBool(streamId)
	self.farmlandId = streamReadUIntN(streamId, g_farmlandManager.numberOfBits)
	self.farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)
    self.price = streamReadInt32(streamId)
	self:run(connection)
end

function LeaseFarmlandEvent:writeStream(streamId, connection)
    streamWriteBool(streamId, self.lease)
	streamWriteUIntN(streamId, self.farmlandId, g_farmlandManager.numberOfBits)
	streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
	streamWriteInt32(streamId, self.price)
end

function LeaseFarmlandEvent:run(connection)
    if self.lease then
        g_fieldLeasingManager:lease(self.farmlandId, self.farmId, self.price)
    else
        g_fieldLeasingManager:terminateLease(self.farmlandId, self.farmId)
    end

    if not connection:getIsServer() then
        if self.lease then
            g_currentMission:addMoney(-self.price * g_fieldLeasingManager:getPriceMultiplier(), self.farmId, MoneyType.FIELD_LEASE, true, true)
        end
        g_server:broadcastEvent(self, false)
    end
end