AnimalCluster.NUM_BITS_AGE = 9

EAS_IncreaseAnimalMaxAge = {}
EAS_IncreaseAnimalMaxAge.maxAge = math.pow(2, AnimalCluster.NUM_BITS_AGE) - 1

function EAS_IncreaseAnimalMaxAge:getAgeFactor(superFunc)
	return MathUtil.clamp(self.age / EAS_IncreaseAnimalMaxAge.maxAge, 0, 1)
end

AnimalCluster.getAgeFactor = Utils.overwrittenFunction(AnimalCluster.getAgeFactor, EAS_IncreaseAnimalMaxAge.getAgeFactor)

function EAS_IncreaseAnimalMaxAge:changeAge(superFunc, delta)
	local old = self.age
	self.age = MathUtil.clamp(math.floor(self.age + delta), 0, EAS_IncreaseAnimalMaxAge.maxAge)

	if math.abs(self.age - old) > 0 then
		self:setDirty()
	end
end

AnimalCluster.changeAge = Utils.overwrittenFunction(AnimalCluster.changeAge, EAS_IncreaseAnimalMaxAge.changeAge)

function EAS_IncreaseAnimalMaxAge:loadFromXMLFile(superFunc, xmlFile, key)
    local returnValue = superFunc(self, xmlFile, key)
	self.age = MathUtil.clamp(xmlFile:getInt(key .. "#age", self.age), 0, EAS_IncreaseAnimalMaxAge.maxAge)

	return returnValue
end

AnimalCluster.loadFromXMLFile = Utils.overwrittenFunction(AnimalCluster.loadFromXMLFile, EAS_IncreaseAnimalMaxAge.loadFromXMLFile)

