local modDirectory = g_currentModDirectory

EAS_AnimalsMenuExtension = {}


function EAS_AnimalsMenuExtension:init()
    InGameMenuAnimalsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuAnimalsFrame.onFrameOpen, EAS_AnimalsMenuExtension.onFrameOpen)
    InGameMenuAnimalsFrame.onListSelectionChanged = Utils.appendedFunction(InGameMenuAnimalsFrame.onListSelectionChanged, EAS_AnimalsMenuExtension.onListSelectionChanged)
    InGameMenuAnimalsFrame.updateAnimalData = Utils.appendedFunction(InGameMenuAnimalsFrame.updateAnimalData, EAS_AnimalsMenuExtension.updateAnimalData)
    InGameMenuAnimalsFrame.updateMenuButtons = Utils.overwrittenFunction(InGameMenuAnimalsFrame.updateMenuButtons, EAS_AnimalsMenuExtension.updateMenuButtons)
end

function EAS_AnimalsMenuExtension:initializeDialogIfNeeded()
    if self.numberOfInseminationDialog == nil then
        self.numberOfInseminationDialog = EAS_NumberPickerDialog.new(self, nil, self.i18n)
        g_gui:loadGui(modDirectory .. "gui/EAS_NumberPickerDialog.xml", "EAS_NumberPickerDialog", self.numberOfInseminationDialog)
    end
end

function EAS_AnimalsMenuExtension:onFrameOpen()
    EAS_AnimalsMenuExtension:initializeDialogIfNeeded()

    if g_inGameMenu.pageAnimals.monthsSinceLastBirth == nil then
        local originalParent = g_inGameMenu.pageAnimals.animalAgeText.parent
        local parent = originalParent:clone(originalParent.parent)

        local info = parent.elements[1]
        info:setText(g_i18n:getText("eas_month_since_last_birth"))

        local value = parent.elements[2]
        value.textOffset[1] = 0.025
        value:setText(EAS_AnimalsMenuExtension.monthSinceLastBirthLabelText())
        g_inGameMenu.pageAnimals.monthsSinceLastBirth = value

        g_inGameMenu.pageAnimals.infoRow[1].parent:addElement(parent)
	end

    if g_inGameMenu.pageAnimals.reproductionState == nil then
        local originalParent = g_inGameMenu.pageAnimals.animalAgeText.parent
        local parent = originalParent:clone(originalParent.parent)

        local info = parent.elements[1]
        info:setText(g_i18n:getText("eas_reproduction_state"))

        local value = parent.elements[2]
        value.textOffset[1] = 0.05
        value.textMaxWidth = 0.2
        value:setText(EAS_AnimalsMenuExtension.reproductionStateText())
        g_inGameMenu.pageAnimals.reproductionState = value

        g_inGameMenu.pageAnimals.infoRow[1].parent:addElement(parent)
	end

    self.animalDataUpdateTime = 0
end

function EAS_AnimalsMenuExtension:onListSelectionChanged()
    EAS_AnimalsMenuExtension.updateMonthSinceLastBirthLabel()
    EAS_AnimalsMenuExtension.updateReproductionState()
end

function EAS_AnimalsMenuExtension:updateMenuButtons(superFunc)
    superFunc(self)

    local selectedHusbandry = g_inGameMenu.pageAnimals.selectedHusbandry
    local selectedCluster = g_inGameMenu.pageAnimals.selectedCluster

    if selectedHusbandry ~= nil and selectedCluster ~= nil then
        local automaticInseminationText = g_i18n:getText("eas_automatic_insemination_on")
        if selectedHusbandry.spec_husbandryAnimals.automaticInsemination then
            automaticInseminationText = g_i18n:getText("eas_automatic_insemination_off")
        end
        self.automaticInseminationButtonInfo = {
            ["inputAction"] = InputAction.MENU_EXTRA_2,
            ["text"] = automaticInseminationText,
            ["callback"] = function()
                EAS_AnimalsMenuExtension.onAutomaticInseminationClicked()
            end
        }
        table.insert(self.menuButtonInfo, self.automaticInseminationButtonInfo)

        local subType = g_currentMission.animalSystem:getSubTypeByIndex(selectedCluster:getSubTypeIndex())
        local isManualInseminationDisabled = selectedHusbandry.spec_husbandryAnimals.automaticInsemination or selectedCluster.isInseminated or subType.reproductionMinAgeMonth > selectedCluster.age or not subType.supportsReproduction

        if not isManualInseminationDisabled then
            self.manualInseminationButtonInfo = {
                ["inputAction"] = InputAction.MENU_ACCEPT,
                ["text"] = g_i18n:getText("eas_manual_insemination"),
                ["callback"] = function()
                    EAS_AnimalsMenuExtension.onManualInseminationClicked()
                end
            }
            table.insert(self.menuButtonInfo, self.manualInseminationButtonInfo)
        end
    end

    EAS_AnimalsMenuExtension.updateMonthSinceLastBirthLabel()
    EAS_AnimalsMenuExtension.updateReproductionState()
end

function EAS_AnimalsMenuExtension:updateAnimalData()
    if self.needUpdateHusbandry then
        self.needUpdateHusbandry = false
        self:updateHusbandries()
        EAS_AnimalsMenuExtension.updateMonthSinceLastBirthLabel()
        EAS_AnimalsMenuExtension.updateReproductionState()
    end
end

-- ################################# Delegates ####################################

function EAS_AnimalsMenuExtension.onAutomaticInseminationClicked(dialog)
    local selectedHusbandry = g_inGameMenu.pageAnimals.selectedHusbandry
    local automaticInsemination = selectedHusbandry.spec_husbandryAnimals.automaticInsemination

    if automaticInsemination then
        automaticInsemination = false
    else
        automaticInsemination = true
    end

    selectedHusbandry.spec_husbandryAnimals.automaticInsemination = automaticInsemination
    g_client:getServerConnection():sendEvent(EAS_UpdateAutomaticInseminationStateEvent.new(selectedHusbandry, automaticInsemination))

	g_inGameMenu.pageAnimals:updateMenuButtons()
end

function EAS_AnimalsMenuExtension.onManualInseminationClicked(dialog)
    EAS_AnimalsMenuExtension.showManualInseminationDialog()
end

function EAS_AnimalsMenuExtension.showManualInseminationDialog()
    local dialog = g_gui.guis.EAS_NumberPickerDialog

    if dialog ~= nil then
        local target = dialog.target
        local selectedCluster = g_inGameMenu.pageAnimals.selectedCluster

        target:setCallback(EAS_AnimalsMenuExtension.manualInseminationCallback, EAS_AnimalsMenuExtension)
        target:setMaxNumAnimals(selectedCluster.numAnimals)

        g_gui:showDialog("EAS_NumberPickerDialog")
    end
end

function EAS_AnimalsMenuExtension.manualInseminationCallback(dialog, numberOfInsemination, success)
    if success then
        local selectedCluster = g_inGameMenu.pageAnimals.selectedCluster
        local selectedHusbandry = g_inGameMenu.pageAnimals.selectedHusbandry

        EAS_InseminationManager.collectInseminationCost(selectedHusbandry.spec_husbandryAnimals, numberOfInsemination)

        g_client:getServerConnection():sendEvent(EAS_InseminateClusterEvent.new(selectedHusbandry, selectedCluster.id, numberOfInsemination))
        g_inGameMenu.pageAnimals.needUpdateHusbandry = true
    end
end

-- ################################# Update month since last birth ####################################

function EAS_AnimalsMenuExtension.updateMonthSinceLastBirthLabel()
    if g_inGameMenu.pageAnimals.monthsSinceLastBirth == nil then
        return
    end

    g_inGameMenu.pageAnimals.monthsSinceLastBirth:setText(EAS_AnimalsMenuExtension.monthSinceLastBirthLabelText())
end

function EAS_AnimalsMenuExtension.updateReproductionState()
    if g_inGameMenu.pageAnimals.reproductionState == nil then
        return
    end

    g_inGameMenu.pageAnimals.reproductionState:setText(EAS_AnimalsMenuExtension.reproductionStateText())
end

function EAS_AnimalsMenuExtension.monthSinceLastBirthLabelText()
    local selectedCluster = g_inGameMenu.pageAnimals.selectedCluster

    if selectedCluster == nil then
        return ""
    end

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(selectedCluster:getSubTypeIndex())
    local neededAge = subType.reproductionMinAgeMonth + subType.reproductionDurationMonth

    if subType.supportsReproduction then
        if selectedCluster.age >= neededAge and selectedCluster.hadABirth then
            return g_i18n:formatNumMonth(selectedCluster.monthsSinceLastBirth)
        else
            return g_i18n:getText("eas_month_since_last_birth_none")
        end
    else
        return ""
    end
end

function EAS_AnimalsMenuExtension.reproductionStateText()
    local selectedCluster = g_inGameMenu.pageAnimals.selectedCluster

    if selectedCluster == nil then
        return ""
    end

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(selectedCluster:getSubTypeIndex())
    local neededAge = subType.reproductionMinAgeMonth

    if not subType.supportsReproduction then
        return g_i18n:getText("eas_animal_did_not_support_reproduction")
    elseif selectedCluster.age < neededAge then
        return g_i18n:getText("eas_animal_too_young")
    elseif selectedCluster.isInseminated and selectedCluster.reproduction == 0 then
        return g_i18n:getText("eas_animal_already_inseminated")
    elseif selectedCluster.isInseminated and selectedCluster.reproduction > 0 then
        return g_i18n:getText("eas_animal_reproduction_in_progress")
    elseif EAS_AnimalCluster.canBeInseminate(selectedCluster) then
        return g_i18n:getText("eas_animal_can_be_inseminate")
    else
        return ""
    end
end