EAS_PlaceableHusbandryMilk = {}

function EAS_PlaceableHusbandryMilk.onHusbandryAnimalsUpdate(self, superFunc, clusters)
	local spec = self.spec_husbandryMilk
	for fillType, _ in pairs(spec.litersPerHour) do
		spec.litersPerHour[fillType] = 0
	end
	spec.activeFillTypes = {}
	for _, cluster in ipairs(clusters) do
		local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster.subTypeIndex)
		if subType ~= nil then
			local litersPerAnimals = subType.output.milk
			if litersPerAnimals ~= nil then
                if cluster.reproduction < 80 and cluster.hadABirth then
                    local age = cluster:getAge()
                    local litersPerDay = litersPerAnimals.curve:get(age) * cluster:getNumAnimals()
                    local lactationFactor = EAS_AnimalCluster.getLactationMilkFactor(cluster)
                    local litersPerHourWithLactation = (litersPerDay / 24) * lactationFactor
                    spec.litersPerHour[litersPerAnimals.fillType] = spec.litersPerHour[litersPerAnimals.fillType] + litersPerHourWithLactation
                end
                table.addElement(spec.activeFillTypes, litersPerAnimals.fillType)
			end
		end
	end
end

PlaceableHusbandryMilk.onHusbandryAnimalsUpdate = Utils.overwrittenFunction(PlaceableHusbandryMilk.onHusbandryAnimalsUpdate, EAS_PlaceableHusbandryMilk.onHusbandryAnimalsUpdate)