AnimalCluster.NUM_BITS_AGE = 9

EAS_AnimalCluster = {}
EAS_AnimalCluster.maxAge = math.pow(2, AnimalCluster.NUM_BITS_AGE) - 1

function EAS_AnimalCluster.new(self, superFunc, customMt)
    local returnValue = superFunc(self, customMt)
    returnValue.isInseminated = false
    returnValue.monthsSinceLastBirth = 0
    returnValue.hadABirth = false
    return returnValue
end

AnimalCluster.new = Utils.overwrittenFunction(AnimalCluster.new, EAS_AnimalCluster.new)

function EAS_AnimalCluster.clone(self, superFunc)
    local returnValue = superFunc(self)
    returnValue.isInseminated = self.isInseminated
    returnValue.monthsSinceLastBirth = self.monthsSinceLastBirth
    returnValue.hadABirth = self.hadABirth
    return returnValue
end

AnimalCluster.clone = Utils.overwrittenFunction(AnimalCluster.clone, EAS_AnimalCluster.clone)

function EAS_AnimalCluster.getHash(self, superFunc)
    local returnValue = superFunc(self)
    local monthsSinceLastBirth = 1000000000000 * (100 + self.monthsSinceLastBirth)
    local isInseminated = 1000000000000000 * 1
    local hadABirth = 1000000000000000 * 1

    if self.isInseminated then
        isInseminated = 1000000000000000 * 2
    end

    if self.hadABirth then
        hadABirth = 1000000000000000 * 2
    end

    local hash = returnValue + monthsSinceLastBirth + isInseminated + hadABirth
    return hash
end

AnimalCluster.getHash = Utils.overwrittenFunction(AnimalCluster.getHash, EAS_AnimalCluster.getHash)

function EAS_AnimalCluster:saveToXMLFile(superFunc, xmlFile, key, usedModNames)
    superFunc(self, xmlFile, key, usedModNames)
	xmlFile:setBool(key .. "#isInseminated", self.isInseminated)
	xmlFile:setInt(key .. "#monthsSinceLastBirth", self.monthsSinceLastBirth)
	xmlFile:setBool(key .. "#hadABirth", self.hadABirth)
end

AnimalCluster.saveToXMLFile = Utils.overwrittenFunction(AnimalCluster.saveToXMLFile, EAS_AnimalCluster.saveToXMLFile)

function EAS_AnimalCluster:loadFromXMLFile(superFunc, xmlFile, key)
    local returnValue = superFunc(self, xmlFile, key)
	self.age = math.clamp(xmlFile:getInt(key .. "#age", self.age), 0, EAS_AnimalCluster.maxAge)
	self.isInseminated = xmlFile:getBool(key .. "#isInseminated")
	self.hadABirth = xmlFile:getBool(key .. "#hadABirth")

    if self.isInseminated == nil then
        self.isInseminated = self.reproduction > 0
    end

	self.monthsSinceLastBirth = xmlFile:getInt(key .. "#monthsSinceLastBirth")

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(self:getSubTypeIndex())
    local neededAge = subType.reproductionMinAgeMonth + subType.reproductionDurationMonth
    if self.monthsSinceLastBirth == nil then
        self.monthsSinceLastBirth = math.ceil(subType.reproductionDurationMonth * (self.reproduction / 100))
    end

    if self.hadABirth == nil then
        if self.age >= neededAge then
            self.hadABirth = true
        else
            self.hadABirth = false
        end
    end

	return returnValue
end

AnimalCluster.loadFromXMLFile = Utils.overwrittenFunction(AnimalCluster.loadFromXMLFile, EAS_AnimalCluster.loadFromXMLFile)

function EAS_AnimalCluster:readStream(superFunc, streamId, connection)
    superFunc(self, streamId, connection)
    self.isInseminated = streamReadBool(streamId)
    self.monthsSinceLastBirth = streamReadInt32(streamId)
    self.hadABirth = streamReadBool(streamId)
end

AnimalCluster.readStream = Utils.overwrittenFunction(AnimalCluster.readStream, EAS_AnimalCluster.readStream)

function EAS_AnimalCluster:writeStream(superFunc, streamId, connection)
    superFunc(self, streamId, connection)
    streamWriteBool(streamId, self.isInseminated)
    streamWriteInt32(streamId, self.monthsSinceLastBirth)
    streamWriteBool(streamId, self.hadABirth)
end

AnimalCluster.writeStream = Utils.overwrittenFunction(AnimalCluster.writeStream, EAS_AnimalCluster.writeStream)

function EAS_AnimalCluster:readUpdateStream(superFunc, streamId, connection)
    superFunc(self, streamId, connection)
    self.isInseminated = streamReadBool(streamId)
    self.monthsSinceLastBirth = streamReadInt32(streamId)
    self.hadABirth = streamReadBool(streamId)
end

AnimalCluster.readUpdateStream = Utils.overwrittenFunction(AnimalCluster.readUpdateStream, EAS_AnimalCluster.readUpdateStream)

function EAS_AnimalCluster:writeUpdateStream(superFunc, streamId, connection)
    superFunc(self, streamId, connection)
    streamWriteBool(streamId, self.isInseminated)
    streamWriteInt32(streamId, self.monthsSinceLastBirth)
    streamWriteBool(streamId, self.hadABirth)
end

AnimalCluster.writeUpdateStream = Utils.overwrittenFunction(AnimalCluster.writeUpdateStream, EAS_AnimalCluster.writeUpdateStream)

function EAS_AnimalCluster:onPeriodChanged(superFunc)
    superFunc(self)

	EAS_AnimalCluster.removeByAgeIfNeeded(self)
end

AnimalCluster.onPeriodChanged = Utils.overwrittenFunction(AnimalCluster.onPeriodChanged, EAS_AnimalCluster.onPeriodChanged)

function EAS_AnimalCluster:getCanReproduce(superFunc)
	local subType = g_currentMission.animalSystem:getSubTypeByIndex(self:getSubTypeIndex())

	if subType.supportsReproduction then
		return subType.reproductionMinAgeMonth <= self.age
	end

	return false
end

AnimalCluster.getCanReproduce = Utils.overwrittenFunction(AnimalCluster.getCanReproduce, EAS_AnimalCluster.getCanReproduce)

function EAS_AnimalCluster:updateReproduction(superFunc)
    if self:getCanReproduce() and self.isInseminated then
		local delta = self:getReproductionDelta(g_currentMission.animalSystem:getSubTypeByIndex(self:getSubTypeIndex()).reproductionDurationMonth)
		if delta > 0 then
			self:changeReproduction(delta)
			if self.reproduction >= 100 then
				self.reproduction = 0
                self.monthsSinceLastBirth = 0
                self.isInseminated = false
                self.hadABirth = true
                local numberOfOffspring = EAS_AnimalCluster.calculateOffspring(self)
				self:setDirty()
				return numberOfOffspring
			end
		end
	end
    self.monthsSinceLastBirth = self.monthsSinceLastBirth + 1
	return 0
end

AnimalCluster.updateReproduction = Utils.overwrittenFunction(AnimalCluster.updateReproduction, EAS_AnimalCluster.updateReproduction)

function EAS_AnimalCluster:getAgeFactor(superFunc)
	return math.clamp(self.age / EAS_AnimalCluster.maxAge, 0, 1)
end

AnimalCluster.getAgeFactor = Utils.overwrittenFunction(AnimalCluster.getAgeFactor, EAS_AnimalCluster.getAgeFactor)

function EAS_AnimalCluster:changeAge(superFunc, delta)
	local old = self.age
	self.age = math.clamp(math.floor(self.age + delta), 0, EAS_AnimalCluster.maxAge)

	if math.abs(self.age - old) > 0 then
		self:setDirty()
	end
end

AnimalCluster.changeAge = Utils.overwrittenFunction(AnimalCluster.changeAge, EAS_AnimalCluster.changeAge)

function EAS_AnimalCluster.calculateOffspring(cluster)
    local offspring = 0
    local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())

    for i=1, cluster.numAnimals do
        local randomIndex = math.random(1, #subType.repoductionProbabilitiesMap)
        offspring = offspring + subType.repoductionProbabilitiesMap[randomIndex]
    end

    return offspring
end

function EAS_AnimalCluster.getLactationFoodFactor(cluster)
    local factor = 1.0
    local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())

    if cluster:getCanReproduce() and cluster.hadABirth and subType.lactation ~= nil and #subType.lactation > 0 then
        for _, lactationValue in ipairs(subType.lactation) do
            if lactationValue.month == cluster.monthsSinceLastBirth + 1 then
                return lactationValue.food
            end
        end
    end

    return factor
end

function EAS_AnimalCluster.getLactationMilkFactor(cluster)
    local factor = 0.0
    local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())

    if cluster:getCanReproduce() and cluster.hadABirth and subType.lactation ~= nil and #subType.lactation > 0 then
        for _, lactationValue in ipairs(subType.lactation) do
            if lactationValue.month == cluster.monthsSinceLastBirth then
                return lactationValue.milk
            end
        end
    end

    return factor
end

function EAS_AnimalCluster.inseminate(self, numAnimals)
    if self.clusterSystem.isServer then
        if numAnimals == self:getNumAnimals() then
            self.isInseminated = true
            self:setDirty()
        else
            local inseminatedCluster = self:clone()
            inseminatedCluster.isInseminated = true
            inseminatedCluster:changeNumAnimals(numAnimals)
            self:changeNumAnimals(-numAnimals)
            self.clusterSystem.owner:addCluster(inseminatedCluster)
        end
	else
		g_client:getServerConnection():sendEvent(EAS_InseminateClusterEvent.new(self.clusterSystem.owner, self.id, numAnimals))
    end
end

function EAS_AnimalCluster.canBeInseminate(self)
    return self:getCanReproduce() and self.reproduction == 0 and self.isInseminated == false
end

function EAS_AnimalCluster.getInseminationProbability(cluster)
    local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())
    local probability = 100

    if subType.inseminationProbabilitiesMap ~= nil and cluster.hadABirth and subType.inseminationProbabilitiesMap[cluster.monthsSinceLastBirth] ~= nil then
        probability = subType.inseminationProbabilitiesMap[cluster.monthsSinceLastBirth]
    end

    local additionalPercentages = 0

    if subType.inseminationTooOldAge ~= nil and subType.inseminationTooOldAgeSteps ~= nil and cluster:getAge() > subType.inseminationTooOldAge then
        additionalPercentages = math.ceil((cluster:getAge() - subType.inseminationTooOldAge) / subType.inseminationTooOldAgeSteps)
    end

    probability = probability - additionalPercentages

    return probability
end

function EAS_AnimalCluster.removeByAgeIfNeeded(cluster)
    if cluster.clusterSystem.owner.ownerFarmId == FarmManager.INVALID_FARM_ID or not g_eas_inGameMenuSettingsFrameExtension:canAnimalsDie() then
        return
    end

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())
    local animalType = g_currentMission.animalSystem:getTypeByIndex(subType.typeIndex)

    if animalType.maxAge ~= nil and animalType.maxAge <= cluster:getAge() then
        local numAnimals = cluster.numAnimals
        for i=1, numAnimals do
            local randomNumber = math.random(1, 100)
            if randomNumber <= animalType.maxAgeDiePercentage then
                cluster:changeNumAnimals(-1)
            end
        end

        if cluster.numAnimals == 0 then
            cluster.clusterSystem:addPendingRemoveCluster(cluster)
        end
    end
end

function EAS_AnimalCluster.removeByHealthIfNeeded(cluster)
    if cluster.clusterSystem.owner.ownerFarmId == FarmManager.INVALID_FARM_ID or not g_eas_inGameMenuSettingsFrameExtension:canAnimalsDie() then
        return
    end

    local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster:getSubTypeIndex())
    local animalType = g_currentMission.animalSystem:getTypeByIndex(subType.typeIndex)

    if cluster.health == 0 then
        local numAnimals = cluster.numAnimals
        for i=1, numAnimals do
            local randomNumber = math.random(1, 100)
            if animalType.healthEmptyDiePercentage ~= nil and randomNumber <= animalType.healthEmptyDiePercentage then
                cluster:changeNumAnimals(-1)
            end
        end

        if cluster.numAnimals == 0 then
            cluster.clusterSystem:addPendingRemoveCluster(cluster)
        end
    end
end
